
#ifndef _BC7262_REG_H_
#define _BC7262_REG_H_

//-----------------------------------------------------------------
#define	BC7262_DEVICE_ADDR			0x72

/*------------- BC7262 register memory map ------------------*/
#define	DIR_CTRL_REQ				0x00
#define	PAS_DLY_REG					0x01

#define	PDU_DATA_REG				0x03
#define	PDU_PTR_REG					0x04
#define	WHT_REG						0x05

#define	PKT_AUTORS_REG				0x06
#define	PKT_APRD_REG				0x07
#define	PKT_PRD_L_REG				0x08
#define	PKT_PRD_H_REG				0x09

#define	PWR_DR_REG					0x0A
#define	TRX_CTL_REG					0x0B
#define	TPCAL_REG					0x0C

#define	LIRC_LSTO_REG				0x11

#define	CFG33_REG					0x33

#define	LIRC_CTL_REG				0x35
#define	RC_CAL_REG					0x36

#define	ACC_ADDR_0_REG				0x39
#define	ACC_ADDR_1_REG				0x3A
#define	ACC_ADDR_2_REG				0x3B
#define	ACC_ADDR_3_REG				0x3C

#define	L2RX_CTL_REG				0x3D
#define	L2RXTO_PRD_REG				0x3E

#define	PKT_CTL_REG					0x3F
#define	PLH1_CTL_REG				0x40
#define	PLH1_LEN_REG				0x41
#define	PLH2_CTL_REG				0x42
#define	PLH2_LEN_REG				0x43

#define	DEV_ADDR_0_REG				0x44
#define	DEV_ADDR_1_REG				0x45
#define	DEV_ADDR_2_REG				0x46
#define	DEV_ADDR_3_REG				0x47
#define	DEV_ADDR_4_REG				0x48
#define	DEV_ADDR_5_REG				0x49

#define	L2_IRQ_REG					0x4A

#define	WL_ADDR_0_REG				0x4B
#define	WL_ADDR_1_REG				0x4C
#define	WL_ADDR_2_REG				0x4D
#define	WL_ADDR_3_REG				0x4E
#define	WL_ADDR_4_REG				0x4F
#define	WL_ADDR_5_REG				0x50

#define	FLT_CTL_REG					0x51

#define	TRXIS_PRD_REG				0x52
#define	RTXIS_PRD_REG				0x53

#define	WLTXA_REG					0x54

#define	GIOS_REG					0x61
#define	GIO_PU_REG					0x62

#define	GIO_CTL_REG					0x61
#define	GIOPU_CTL_REG				0x62
#define	GIOPU_DRV_REG				0x63

#define	CFG70_REG					0x70

#define	VCOCAL_REQ					0x72

#define MATCH_FLAG_REG				0x8B
#define	CHIPID_REG					0x8C
#define	CHIPVER_REG					0x8E


/*----------------- XO Control Register -----------------*/
#define	_FLUSH_FIFO_		0x80

/*----------------- packet format Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
		unsigned char  bkmode : 1;
		unsigned char  fifo_sel : 1;
		unsigned char  pdud_rs : 1;	
		unsigned char  plden : 1;
		unsigned char  whten : 1;
		unsigned char  pmlen : 1;		
		unsigned char : 2;
	}bits;
}pkt_ctl_t;

enum
{
	BROADCASTER = 0,
	OBSERVER,
};

enum
{
	FIFO0 = 0,
	FIFO1,
};

enum
{
	REGISTERR_DATA = 0,
	RECEIVER_DATA,
};

enum
{
	ONE_BYTE_PRM = 0,
	TWO_BYTE_PRM,
};

/*----------------- Crystal and Direct Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
    	unsigned char  rtx_en : 1;
    	unsigned char  rtx_sel : 1;
    	unsigned char  sx_en : 1;
    	unsigned char  xodiv2 : 1;
    	unsigned char  xo_sel : 1;
		unsigned char  xrdy_dly : 2;
		unsigned char  pwron : 1;
	}bits;
}xdir_ctl_t;

/*----------------- whitening Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
    	unsigned char  whtsd : 7;
		unsigned char  whtsds : 1;
	}bits;
}wht_ctl_t;

/*----------------- Auto period retransmit delay Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
		unsigned char	pkt_aprd : 5;
		unsigned char	rnddly_en : 1;		
		unsigned char	aprd_pdth : 2;
	}bits;
}aprd_ctl_t;

/*----------------- data rate & Tx power Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
		unsigned char  data_rate : 3;
		unsigned char : 1;
		unsigned char  tx_power : 3;
		unsigned char : 1;		
	} bits;
}drtxp_ctl_t;

typedef enum
{
	N10DBM = 0,
	N05DBM,
	P00DBM,
	P02DBM,
	P05DBM,
	P07DBM,
}tx_pwr_e;


typedef enum
{
	CH37 = 2,
	CH38 = 26,
	CH39 = 80,
}channel_e;

/*----------------- Hopping frequency & TX start Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
		unsigned char  ch37en : 1;
		unsigned char  ch38en : 1;
		unsigned char  ch39en : 1;
		unsigned char : 1;
		unsigned char  l2tx_start : 1;
 		unsigned char  l2rx_start : 1;
		unsigned char : 1;
		unsigned char  l2rsp_en : 1;
  } bits;
}txsfno_ctl_t;

/*----------------- IRQ Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
		unsigned char  irq_l2tx : 1;
		unsigned char  irq_l2rx : 1;
		unsigned char : 5;
		unsigned char  l2rxto_f : 1;
  } bits;
}irq_t;

/*----------------- LIRC Control Register -----------------*/
typedef union 
{
	unsigned char	value;
	struct 
	{
		unsigned char  lircclks : 1;
		unsigned char  lircss : 1;
		unsigned char  wot_tu : 1;
		unsigned char  rftxm : 1;
		unsigned char  lstom : 2;
		unsigned char  lstos : 1;
		unsigned char  : 1;
	} bits;
}lirc_ctl_t;

/*------------------ GPIO Control Register -------------------------*/
typedef union 
{
	unsigned char value;
	struct 
	{
		unsigned char gio1 : 3;
		unsigned char : 1;
		unsigned char gio2 : 3;
		unsigned char : 1;
	} bits;
} gio_ctl_t;

enum 
{
	INPUT_MODE = 0,         // GPIO input mode
	FSYCK_OUTPUT,       	// FSYCK (output)
	TBCLK_OUTPUT,			// TBCLK/RBIT_CLK(output) 
	TXD_OUTPUT,           	// TXD/BDATA_OUT(output)
	ETXD_INPUT,				// ETXD (input)
	LIRCCLK,             	// LIRCCLK(output when LIRCCLKS=0, input when LIRCCLKS=1)
	IRQ_L2ACT,            	// IRQ_L2ACT (output)
	L2TRX_START,			// L2TX_START || L2RXSTART (output)
};

/*------------------ GPIO pull-up Control Register -------------------------*/
typedef union 
{
	unsigned char value;
	struct 
	{
		unsigned char giopu : 5;
		unsigned char sclpu : 1;
		unsigned char sdapu : 1;
		unsigned char irqact : 1;
	} bits;
} giopu_ctl_t;

/*------------------ White Filter Register -------------------------*/
typedef union 
{
	unsigned char value;
	struct 
	{
		unsigned char rxadvi_fen : 1;		//00h
		unsigned char rxadvdi_fen : 1;		//01h
		unsigned char rxadvni_fen : 1;		//02h
		unsigned char : 2;
		unsigned char wla_en : 1;
		unsigned char rxadvsi_fen : 1;		//06h
		unsigned char rxplht_fen : 1;
	} bits;
} wht_flt_t;

enum
{
	RXADVNI_FEN	= 0,
	RXADVSI_FEN,
	RXSRQ_FEN,
	RXADVI_FEN,
	RXADVDI_FEN,
	RXPLHT_FEN = 7,
};

enum
{
	PUB_ADDR = 0,
	RAND_ADDR
};

/*------------------ layer 2 state Register -------------------------*/
#if	(_OLD_VER_==0)
#define	RTR_MATCH_FLAG	0xB0
#define RTR_MASK		0xBF
#else
#define	RTR_MATCH_FLAG	0xA2
#define RTR_MASK		0xFB
#endif

typedef union 
{
	unsigned char value;
	struct 
	{
	#if	(_OLD_VER_==0)
		unsigned char rxadvi : 1;		//RXADVI_OKGRX ADV_IND OK state in layer 2
		unsigned char rxadvdi : 1;		//RXADVDI_MATCHGRX ADV_DIRECT_IND match state in layer 2
		unsigned char rxadvni : 1;		//RXADVNI_OKGRX ADV_NOCONN_IND OK state in layer 2
		unsigned char srqa : 1;			//SRQA_MATCHGScan request match state in layer 2.
		unsigned char srpv : 1;			//SRP_VLDGRX SCAN_RSP type match OK and CRC pass in layer 2
		unsigned char wla : 1;			//WLA_MATCHGWhite list address match state in layer 2
		unsigned char rxadvsi : 1;		//RXADVSI_OKGRX ADV_SCAN_IND OK state in layer 2
		unsigned char srp : 1;			//SRP_MATCHGScan response match state in layer 2
	#else
		unsigned char srqa : 1;			//SRQA_MATCHGScan request match state in layer 2.
		unsigned char srpa : 1;			//SRPA_MATCHGScan response match state in layer 2
		unsigned char wla : 1;			//WLA_MATCHGWhite list address match state in layer 2
		unsigned char rxadvdi : 1;		//RXADVDI_MATCHGRX ADV_DIRECT_IND match state in layer 2
		unsigned char rxadvni : 1;		//RXADVNI_OKGRX ADV_NOCONN_IND OK state in layer 2
		unsigned char rxadvsi : 1;		//RXADVSI_OKGRX ADV_SCAN_IND OK state in layer 2
		unsigned char rxadvi : 1;		//RXADVI_OKGRX ADV_IND OK state in layer 2
		unsigned char srp : 1;			//SRP_VLDGRX SCAN_RSP valid state in layer 2
	#endif
	} bits;
} l2_state_t;


#endif	/* _BC7262_REG_H_ */
